<?php

namespace App\Models;

use CodeIgniter\Model;

class InvoiceModel extends Model
{
    protected $table            = 'invoices';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['lab_number', 'patient_id', 'referred_by', 'invoice_date', 'total_amount', 'paid_amount', 'balance', 'collecting_date'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    // protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'lab_number'      => 'required|regex_match[/^\d{8}-[a-zA-Z0-9]{1,6}$/]',
        'patient_id'      => 'required|integer|checkPatientExists',
        'referred_by'     => 'permit_empty|min_length[3]|max_length[255]',
        'invoice_date'    => 'required|valid_datetime[Y-m-d H:i]',
        'total_amount'    => 'required|decimal',
        'paid_amount'     => 'required|decimal',
        'balance'         => 'required|decimal',
        'collecting_date' => 'required|valid_datetime[Y-m-d H:i]',
    ];
    protected $validationMessages   = [
        'lab_number' => [
            'required' => 'Lab number is required.',
            'regex_match' => 'Lab number must be in the format DDMMYYYY-XXXXXX',
        ],
        'patient_id' => [
            'required' => 'Patient ID is required.',
            'integer'  => 'Patient ID must be an integer.',
            'checkPatientExists' => 'Patient ID must exist in the patients table.',
        ],
        'referred_by' => [
            'alpha_numeric_space' => 'Referred by must contain only alphanumeric characters and spaces.',
            'min_length' => 'Referred by must be at least 3 characters long.',
            'max_length' => 'Referred by cannot exceed 255 characters.',
        ],
        'invoice_date' => [
            'required' => 'Invoice date is required.',
            'valid_datetime' => 'Invoice date must be a valid datetime.',
        ],
        'total_amount' => [
            'required' => 'Total amount is required.',
            'decimal'  => 'Total amount must be a decimal number.',
        ],
        'paid_amount' => [
            'required' => 'Paid amount is required.',
            'decimal'  => 'Paid amount must be a decimal number.',
        ],
        'balance' => [
            'required' => 'Balance is required.',
            'decimal'  => 'Balance must be a decimal number.',
        ],
        'collecting_date' => [
            'required' => 'Collecting date is required.',
            'valid_datetime' => 'Collecting date must be a valid datetime.',
        ],
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
